Attribute VB_Name = "mdCreateLine"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to Create a line between two points (startX,startY) and endX,endY)

Function CreateLine(startX As Double, startY As Double, endX As Double, endY As Double)

'To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

'To create a line from the input
Dim startvector As ZVector
Set startvector = app.GetClass("Vector").CreateVector(startX, startY, 0)

Dim endvector As ZVector
Set endvector = app.GetClass("Vector").CreateVector(endX, endY, 0)

If startvector.IsEqualTo(endvector) Then
    MsgBox "Invalid Input: The StartPoint and EndPoint are same"
    Set CreateLine = Nothing
    Exit Function
End If

Dim curve1 As zCurve
Set curve1 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(wp.Get3DVector(startvector), wp.Get3DVector(endvector))

Dim line1 As aLine
Set line1 = sketch.CreateLine(curve1)

wp.AutoConstrain line1

Set CreateLine = line1

End Function


